﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja miesięczna</title>
		<script runat="server">

    public enum MiejscPoPrzecinku {
        [Caption("2")]
        Dwa = 2,
        [Caption("3")]
        Trzy = 3,
    }

	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			miesiąc = new YearMonth(data);
		}
		
		YearMonth miesiąc;
		[Required]
        [Priority(10)]
        [Caption("Raport za")]
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set { 
				miesiąc = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        ZPCHR.WarunkiNaliczania warunkiNaliczaniaDla = ZPCHR.WarunkiNaliczania.PFRON;
        [Priority(20)]
        public ZPCHR.WarunkiNaliczania WarunkiNaliczaniaDla {
            get { return warunkiNaliczaniaDla; }
            set {
                warunkiNaliczaniaDla = value;
                OnChanged(EventArgs.Empty);
            }
        }

        MiejscPoPrzecinku zaokraglenie = MiejscPoPrzecinku.Dwa;
        [Priority(30)]
        [Caption("Zaokrąglenie")]
        public MiejscPoPrzecinku Zaokraglenie {
            get { return zaokraglenie; }
            set {
                zaokraglenie = value;
                OnChanged(EventArgs.Empty);
            }
        }

        internal int Precyzja { get { return (int)zaokraglenie; } }
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	}

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool zaznaczeni = false;
        [Priority(1)]
        [Caption("Pracownicy wg listy")]
        public bool Zaznaczeni {
            get { return zaznaczeni; }
            set {
                zaznaczeni = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
    
    Dictionary<OddzialFirmy, List<Pracownik>> dict = new Dictionary<OddzialFirmy, List<Pracownik>>();
    List<OddzialFirmy> oddzialy = new List<OddzialFirmy>();
    string title;
    ZPCHR zpchr;
    
	void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
        ReportHeader1["RAPORT"] = CaptionAttribute.EnumToString(pars.WarunkiNaliczaniaDla);
        title = ReportHeader1.Title;

        eo.Format = en.Format = el.Format = eu.Format = eus.Format = ez.Format = ezs.Format =
            zo.Format = zl.Format = zu.Format = zz.Format = zus.Format = zzs.Format = wzon.Format =
            wzon_l.Format = wzon_u.Format = wzon_z.Format = wzon_uz.Format = owzon.Format = 
            (pars.Zaokraglenie == MiejscPoPrzecinku.Dwa ? "{0:n}" : "{0:n3}");
		
        bool jestZpchr = Soneta.Core.CoreModule.GetInstance(dc).Config.Firma.StatusZPChr.Posiada;
        zpchr = new ZPCHR(jestZpchr, pars.Miesiąc, pars.WarunkiNaliczaniaDla);

        IEnumerable rows;
        if (srpars.Zaznaczeni)
            rows = (Pracownik[])dc[typeof(Pracownik[])];
        else
            rows = KadryModule.GetInstance(dc).Pracownicy.GetNaEtatach(pars.Miesiąc.ToFromTo(), (Wydzial)null, false, true);

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Miesiąc.FirstDay;
            foreach (Pracownik pracownik in rows) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(new OddzialFirmy(RowCreator.Empty), list = new List<Pracownik>());
            foreach (Pracownik pracownik in rows)
                list.Add(pracownik);
        }
        
        ArrayList lista = new ArrayList();
        oddzialy.AddRange(dict.Keys);
        foreach (OddzialFirmy of in oddzialy)
            lista.Add(zpchr.Razem(dict[of], pars.Precyzja));
        DataRepeater1.DataSource = lista;
	}

	void OnBeforeRow(Object sender, EventArgs args) {
        OddzialFirmy of = oddzialy[0];
        oddzialy.Remove(of);
        ReportHeader1.Title = !string.IsNullOrEmpty(of.Symbol) ? title.Replace("%ODDZIAL%", "Oddział: " + of) : title.Replace("%ODDZIAL%", "");

        ZPCHR.MiesiącInfo mi = (ZPCHR.MiesiącInfo)DataRepeater1.CurrentRow;
        Podsumowanie(mi);
        
        Grid1.DataSource = zpchr.Dni(dict[of], pars.Precyzja);
    }

    void Podsumowanie(ZPCHR.MiesiącInfo mi) {
        decimal wo = mi.Etaty;
        decimal wl = mi.EtatyLekki;
        decimal wu = mi.EtatyUmiarkowany;
        decimal wz = mi.EtatyZnaczny;
        decimal wus = mi.EtatyUmiarkowanySchorzenia;
        decimal wzs = mi.EtatyZnacznySchorzenia;
        
		zo.EditValue = wo;		
		zl.EditValue = wl;
		zu.EditValue = wu;
		zz.EditValue = wz;
		zus.EditValue = wus;
		zzs.EditValue = wzs;

        if (wo > 0m) {
		    wzon.EditValue = 100 * (wl + wu + wz)/wo;
			wzon_l.EditValue = 100 * wl/wo;
			wzon_u.EditValue = 100 * wu/wo;
			wzon_z.EditValue = 100 * wz/wo;
			wzon_uz.EditValue = 100 * (wu + wz)/wo;
			decimal x = (wus * 2 + wzs * 3)/wo;
			if (x>=0.06m)
				x = 0m;
			else 
				x = 0.06m - x;
			owzon.EditValue = 100 * x;
		}
	}
	
	static void Msg(object obj) {
	}
	
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięczna" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" RowTypeName="Soneta.Kadry.ZPCHR+MiesiącInfo,Soneta.KadryPlace"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
			    <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA MIESIĘCZNA O WSKAŹNIKACH ZATRUDNIENIA OSÓB NIEPEŁNOSPRAWNYCH|&lt;/strong&gt;Raport za: &lt;strong&gt;%MIESIĄC%|&lt;/strong&gt;Statystyka: &lt;strong&gt;%RAPORT%|%ODDZIAL%"
				    runat="server"></cc1:reportheader>
			    <ea:grid id="Grid1" runat="server" ShowSum="Never">
				    <Columns>
					    <ea:GridColumn Width="5" RightBorder="Double" Align="Center" DataMember="#" Caption="|Dzień||(1)"
						    NoWrap="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Pracownicy" Total="Sum" Caption="Zatrudnienie w osobach~Pracownicy og&#243;łem|(2)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Niepełnosprawni" Total="Sum" Caption="Zatrudnienie w osobach~Niepełnosprawni og&#243;łem|(3)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Lekki" Total="Sum" Caption="Zatrudnienie w osobach~|Lekki|(4)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Umiarkowany" Total="Sum" Caption="Zatrudnienie w osobach~|Umiarkowany|(5)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Znaczny" Total="Sum" Caption="Zatrudnienie w osobach~|Znaczny|(6)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Etaty" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Pracownicy og&#243;łem|(7)"
						    HideZero="True" ID="eo"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyNiepełnosprawni" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Niepełnosprawni og&#243;łem|(8)"
						    HideZero="True" ID="en"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyLekki" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Lekki|(9)"
						    HideZero="True" ID="el"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyUmiarkowany" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Umiarkowany|(10)"
						    HideZero="True" ID="eu"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyUmiarkowanySchorzenia" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Umiarkowany|(schorz.)|(11)"
						    HideZero="True" ID="eus"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyZnaczny" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Znaczny|(12)"
						    HideZero="True" ID="ez"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyZnacznySchorzenia" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Znaczny|(schorz.)|(13)"
						    HideZero="True" ID="ezs"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
			    <P>
				    <TABLE id="Table1" cellSpacing="0" width="100%">
					    <TR>
						    <TD width="80%"><FONT face="Tahoma" size="2"><FONT face="Tahoma" size="2">Przeciętne 
									    miesięczne zatrudnienie </FONT>ogółem </FONT>
						    </TD>
						    <TD align="right">
							    <ea:DataLabel id="zo" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></TD>
						    <TD align="right" width="3%"><FONT face="Tahoma" size="2"></FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2"> ...osób o&nbsp;lekkim stopniu niepełnosprawności</FONT></TD>
						    <TD align="right">
							    <ea:DataLabel id="zl" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></TD>
						    <TD align="right"><FONT face="Tahoma" size="2"></FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2"> ...osób o&nbsp;umiarkowanym stopniu 
								    niepełnosprawności</FONT></TD>
						    <TD align="right">
							    <ea:DataLabel id="zu" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></TD>
						    <TD align="right"><FONT face="Tahoma" size="2"></FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2"> ...osób o znacznym stopniu niepełnosprawności</FONT></TD>
						    <TD align="right">
							    <ea:DataLabel id="zz" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></TD>
						    <TD align="right"><FONT face="Tahoma" size="2"></FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2">...osób o&nbsp;umiarkowanym&nbsp;stopniu 
								    niepełnosprawności&nbsp;i szczególnych schorzeniach</FONT></TD>
						    <TD align="right">
							    <P align="right">
								    <ea:DataLabel id="zus" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2"></FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2">...osób o znacznym&nbsp;stopniu 
								    niepełnosprawności&nbsp;i szczególnych schorzeniach</FONT></TD>
						    <TD align="right">
							    <P align="right">
								    <ea:DataLabel id="zzs" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2"></FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2"><STRONG>Wskaźnik zatrudnienia osób niepełnosprawnych</STRONG></FONT></TD>
						    <TD align="right">
							    <P align="right">
								    <ea:DataLabel id="wzon" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2">%</FONT></TD>
					    </TR>
					    <TR>
						    <TD>
							    <P><FONT face="Tahoma" size="2"><STRONG>... o lekkim stopniu niepełnosprawności</STRONG></FONT></P>
						    </TD>
						    <TD align="right">
							    <P align="right">
								    <ea:DataLabel id="wzon_l" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2">%</FONT></TD>
					    </TR>
					    <TR>
						    <TD><STRONG><FONT face="Tahoma" size="2">... o umiarkowanym stopniu niepełnosprawności</FONT></STRONG></TD>
						    <TD align="right">
							    <P align="right">
								    <ea:DataLabel id="wzon_u" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2">%</FONT></TD>
					    </TR>
					    <TR>
						    <TD><STRONG><FONT face="Tahoma" size="2">... o znacznym stopniu niepełnosprawności</FONT></STRONG></TD>
						    <TD align="right">
							    <P align="right">
								    <ea:DataLabel id="wzon_z" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2">%</FONT></TD>
					    </TR>
					    <TR>
						    <TD><STRONG><FONT face="Tahoma" size="2">... o umiarkowanym i znacznym stopniu niepełnosprawności</FONT></STRONG></TD>
						    <TD align="right">
					            <P align="right">
							        <ea:DataLabel id="wzon_uz" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2">%</FONT></TD>
					    </TR>
					    <TR>
						    <TD><FONT face="Tahoma" size="2"><STRONG>Obniżony wskaźnik zatrudnienia osób 
									    niepełnosprawnych</STRONG></FONT></TD>
						    <TD>
							    <P align="right">
								    <ea:DataLabel id="owzon" runat="server"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></P>
						    </TD>
						    <TD align="right"><FONT face="Tahoma" size="2">%</FONT></TD>
					    </TR>
				    </TABLE>
			    </P>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>

